;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeWithMultipleMedia.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.7  $
;          $Date:   07 Oct 2005 17:18:08  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeWithMultipleMedia.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Slightly more complicate example than "TryMe.MM".
;
; Demonstrates how you can create multiple cabs for multiple CD-ROM or other
; media.
;
; I used a very large value for "COMPILE_RESERVED_BYTES_ON_MEDIA1" to ensure
; that we will generate at least 2 cab files for the purposes of this example.
;
; To test the generated MSI you will either need to create the MEDIA or
; copy the cab in "MSI\OtherDisks.MSI\AppDisk #2" to the "MSI" directory.
; The "AppDisk #2" is the default directory for cabs for disk 2 and also
; by default the correct volume label for this disk is "AppDisk #2".
;
; TAKE NOTE
; ~~~~~~~~~
; Note that by default DEVELOPMENT mode puts all the cabs in the MSI
; directory to make testing simple (no need to create media). When built
; in PRODUCTION mode the cabs for disk 2 onwards will be generated
; into "media" directories.
;----------------------------------------------------------------------------


;--- Override some MAKEMSI options ------------------------------------------
#define  VER_FILENAME.VER  TryMe.Ver  ;;I only want one VER file for all samples!


;--- Override SOME Cabinet settings -----------------------------------------
#define COMPILE_TYPE                        <$COMPILE_CAB_EXTERNAL_WITH_MSI> ;;Cabs obviously can't be imbedded in the MSI!
#define COMPILE_CABDDF_MaxDiskSize          <$COMPRESS_CAPACITY_CDROM>       ;;How big is the media (default = "unlimited")?
#define COMPILE_MEDIA_VolumeLabel_TEMPLATE  MyApp Disk #{#}                  ;;What labels will the media have (media insertion will be validated)


;--- "Stupid" values to ensure we get 2 cabs over 2 media -------------------
#define+ COMPILE_CABDDF_MaxDiskSize         600000    ;;Approx 600K (overrides realistic value above)
#define COMPILE_RESERVED_BYTES_ON_MEDIA1    200000    ;;Approx 200K


;--- Include MAKEMSI support (with my customisations and MSI branding) ------
#include "ME.MMH"


;--- Create INSTALLDIR ------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PRIMARYFOLDER="Y">


;--- Grab a fair few files (any will do as long as a reasonable number of bytes) ---
<$Component "TryMe" Create="Y" Directory_="INSTALLDIR">
    ;--- Add the files to the "TryMe" component -----------------------------
    <$Files "..\..\..\*.mmh;*.exe" KeyFile="*">       ;;The installed MAKEMSI files
<$/Component>


